import os
import sys
import git
import time
import math
import random
import datetime
import pathlib
import subprocess
from collections import defaultdict, deque
import GPUtil
import numpy as np
import torch

from googleapiclient.discovery import build
from googleapiclient.http import MediaFileUpload
from google.oauth2.credentials import Credentials
from google_auth_oauthlib.flow import InstalledAppFlow
from oauth2client.file import Storage
from oauth2client import client, tools


def init_wandb(args):
    import wandb
    # wandb_path = os.path.join(args.wandb_dir, 'ec', args.exp, 'analysis')
    legend = get_legend()
    args.output_path = get_path(args.output_dir, args.exp)
    if len(args.exp_load) > 0: args.load_path = get_path(args.output_dir,
                                                         args.exp_load)
    args.chkpt_path = os.path.join(args.output_path, 'chkpt_final.pth')
    wandb_path= get_path(args.wandb_dir, args.exp)

    wandb.init(project=args.proj_name, name=legend, tags=args.tags,
               dir=wandb_path, entity=args.wandb_entity)
    wandb.config.update(args, allow_val_change=True)
    print("git:\n  {}\n".format(get_sha()))
    print("\n".join("%s: %s" % (k, str(v)) for k, v in sorted(dict(vars(args)).items())))


def get_path(dir, exp):
    path = os.path.join(dir, exp)
    pathlib.Path(path).mkdir(parents=True, exist_ok=True)
    return path


def set_seed(seed):
    if seed >= 0:
        import numpy as np
        import random
        import torch
        np.random.seed(seed)
        torch.manual_seed(seed)
        torch.cuda.manual_seed(seed)
        random.seed(seed)
        torch.backends.cudnn.deterministic = True
        os.environ['PYTHONHASHSEED'] = str(seed)


def get_sha():
    cwd = os.path.dirname(os.path.abspath(__file__))

    def _run(command):
        return subprocess.check_output(command, cwd=cwd).decode('ascii').strip()
    sha = 'N/A'
    diff = "clean"
    branch = 'N/A'
    try:
        sha = _run(['git', 'rev-parse', 'HEAD'])
        subprocess.check_output(['git', 'diff'], cwd=cwd)
        diff = _run(['git', 'diff-index', 'HEAD'])
        diff = "has uncommited changes" if diff else "clean"
        branch = _run(['git', 'rev-parse', '--abbrev-ref', 'HEAD'])
    except Exception:
        pass
    message = f"sha: {sha}, status: {diff}, branch: {branch}"
    return message


def get_legend():
    a = sys.argv[1:]
    s = ''
    for k, v in zip(a[::2], a[1::2]):
        s += '{}:{},'.format(k.replace('--', ''), v)
    repo = git.Repo(search_parent_directories=True)
    sha = repo.head.object.hexsha
    s += '{}'.format(sha[:6])
    return s


def bool_flag(s):
    """
    Parse boolean arguments from the command line.
    """
    FALSY_STRINGS = {"off", "false", "0"}
    TRUTHY_STRINGS = {"on", "true", "1"}
    if s.lower() in FALSY_STRINGS:
        return False
    elif s.lower() in TRUTHY_STRINGS:
        return True
    else:
        raise argparse.ArgumentTypeError("invalid value for a boolean flag")


def get_valid_unit(x):
    import math
    if x == 0.0:
        return x
    # num_digits = math.floor(math.log10(abs(x))) + 1
    result = round(x, 3)
    return result


def get_current_git_hash():
    try:
        result = subprocess.check_output(["git", "rev-parse", "HEAD"]).strip()
        git_hash = result.decode("utf-8")
    except subprocess.CalledProcessError:
        git_hash = None
    return git_hash[:6]
    

def upload_csv(args, desc):
    upload_path = desc.replace('   ', '_')
     
    SCOPES = [
        'https://www.googleapis.com/auth/drive',        
    ]
    parents_ids = {
        'cifar10' : '1sGHhK3SLdHAm8Sebrjx4yg7el8bdIJSg',
        'cifar100' : "1T5Btmk7LyWp3aMkJtoaoatdKC1IKfPPT"
    }
    
    if os.path.exists('js_file/token.json'):
        creds = Credentials.from_authorized_user_file('js_file/token.json', SCOPES)
    else:
        flow = InstalledAppFlow.from_client_secrets_file(
            'js_file/client.json', SCOPES
        )
        creds = flow.run_local_server(port=0)
        with open('token.json', 'w') as token:
            token.write(creds.to_json())
    drive_service = build('drive', 'v3', credentials=creds)

    # mkdir
    if len(args.upload_dir) == 0:
        args.upload_dir = 'test'
    request_body = {
        'name': args.upload_dir,
        'parents': [parents_ids[args.dataset]],
        'mimeType': 'application/vnd.google-apps.folder'
    }
    folder_id = drive_service.files().create(body=request_body, fields='id').execute()
    folder_id = folder_id.get('id')
    print("Folder Link:", f'https://drive.google.com/drive/folders/{folder_id}')
    request_body = {
        'name': f'{upload_path}_{args.start_time}_{get_current_git_hash()}',
        'parents': [folder_id],
        'mimeType': 'application/vnd.google-apps.folder'
    }
    folder_id = drive_service.files().create(body=request_body, fields='id').execute()
    folder_id = folder_id.get('id')

    for amp_s in ['max', 'top1', 'top2', 'all']:
        file_path = os.path.join(args.output_path, f'{amp_s}.csv')
        request_body = {
            'name': f'{amp_s}.csv', # filename
            'parents': [folder_id]
        }
        media = MediaFileUpload(file_path, mimetype='text/csv')
        file_info = drive_service.files().create(
            body=request_body, media_body=media, fields='id,webViewLink').execute()
        # webviewlink = file_info.get('webViewLink')
        # print(f"Uploaded file to Google Drive: {webviewlink}")
    file_path = os.path.join(args.output_path, 'calibration.csv')
    request_body = {
            'name': f'calibration.csv', # filename
            'parents': [folder_id]
        }
    media = MediaFileUpload(file_path, mimetype='text/csv')
    file_info = drive_service.files().create(
        body=request_body, media_body=media, fields='id,webViewLink').execute()